'use strict';

/* --------------------------------------------------------------
   EasyCreditLoader.js 2020-04-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

(function () {
	if (window.NodeList && !NodeList.prototype.forEach) {
		NodeList.prototype.forEach = Array.prototype.forEach;
	}

	var currentScript = document.currentScript;

	var pluginLoaded = function pluginLoaded() {
		var placeholderElement = document.querySelector('div.easycredit-rr-container');
		if (!placeholderElement) {
			return;
		}

		var styleSrc = 'https://ratenkauf.easycredit.de/ratenkauf/js/ratenrechner/v1/ratenrechner.css';
		var pluginStyle = document.createElement('link');
		pluginStyle.rel = 'stylesheet';
		pluginStyle.type = 'text/css';
		pluginStyle.href = styleSrc;
		if (currentScript) {
			currentScript.parentNode.insertBefore(pluginStyle, currentScript);
		} else {
			document.querySelector('script:last-of-type').parentNode.appendChild(pluginStyle);
		}

		rkPlugin.anzeige(placeholderElement.id, {
			webshopId: easyCreditParameters.shopId,
			finanzierungsbetrag: easyCreditParameters.finanzierungsbetrag,
			euro: easyCreditParameters.euro,
			textVariante: easyCreditParameters.textVariante,
			linkText: easyCreditParameters.linkText,
			fromText: easyCreditParameters.fromText,
			installmentTemplate: easyCreditParameters.installmentTemplate,
			widgetTemplate: easyCreditParameters.widgetTemplate
		});
	};

	var readyCallback = function readyCallback() {
		if (typeof window.rkPlugin === 'undefined') {
			var pluginSrc = 'https://ratenkauf.easycredit.de/ratenkauf/js/ratenrechner/v1/ratenrechner.js';
			var pluginScript = document.createElement('script');
			pluginScript.src = pluginSrc;
			pluginScript.onload = pluginLoaded;

			if (currentScript) {
				currentScript.parentNode.insertBefore(pluginScript, currentScript);
			} else {
				document.querySelector('script:last-of-type').parentNode.appendChild(pluginScript);
			}
		}
	};

	if (document.readyState === 'complete' || document.readyState !== 'loading' && !document.documentElement.doScroll) {
		readyCallback();
	} else {
		document.addEventListener('DOMContentLoaded', readyCallback);
	}
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIlNob3AvSmF2YXNjcmlwdC9FYXN5Q3JlZGl0TG9hZGVyLmpzIl0sIm5hbWVzIjpbIndpbmRvdyIsIk5vZGVMaXN0IiwicHJvdG90eXBlIiwiZm9yRWFjaCIsIkFycmF5IiwiY3VycmVudFNjcmlwdCIsImRvY3VtZW50IiwicGx1Z2luTG9hZGVkIiwicGxhY2Vob2xkZXJFbGVtZW50IiwicXVlcnlTZWxlY3RvciIsInN0eWxlU3JjIiwicGx1Z2luU3R5bGUiLCJjcmVhdGVFbGVtZW50IiwicmVsIiwidHlwZSIsImhyZWYiLCJwYXJlbnROb2RlIiwiaW5zZXJ0QmVmb3JlIiwiYXBwZW5kQ2hpbGQiLCJya1BsdWdpbiIsImFuemVpZ2UiLCJpZCIsIndlYnNob3BJZCIsImVhc3lDcmVkaXRQYXJhbWV0ZXJzIiwic2hvcElkIiwiZmluYW56aWVydW5nc2JldHJhZyIsImV1cm8iLCJ0ZXh0VmFyaWFudGUiLCJsaW5rVGV4dCIsImZyb21UZXh0IiwiaW5zdGFsbG1lbnRUZW1wbGF0ZSIsIndpZGdldFRlbXBsYXRlIiwicmVhZHlDYWxsYmFjayIsInBsdWdpblNyYyIsInBsdWdpblNjcmlwdCIsInNyYyIsIm9ubG9hZCIsInJlYWR5U3RhdGUiLCJkb2N1bWVudEVsZW1lbnQiLCJkb1Njcm9sbCIsImFkZEV2ZW50TGlzdGVuZXIiXSwibWFwcGluZ3MiOiI7O0FBQUE7Ozs7Ozs7Ozs7QUFVQyxhQUFXO0FBQ1gsS0FBSUEsT0FBT0MsUUFBUCxJQUFtQixDQUFDQSxTQUFTQyxTQUFULENBQW1CQyxPQUEzQyxFQUFvRDtBQUNuREYsV0FBU0MsU0FBVCxDQUFtQkMsT0FBbkIsR0FBNkJDLE1BQU1GLFNBQU4sQ0FBZ0JDLE9BQTdDO0FBQ0E7O0FBRUQsS0FBSUUsZ0JBQWdCQyxTQUFTRCxhQUE3Qjs7QUFFQSxLQUFJRSxlQUFlLFNBQWZBLFlBQWUsR0FBVztBQUM3QixNQUFJQyxxQkFBcUJGLFNBQVNHLGFBQVQsQ0FBdUIsNkJBQXZCLENBQXpCO0FBQ0EsTUFBRyxDQUFDRCxrQkFBSixFQUF3QjtBQUN2QjtBQUNBOztBQUVELE1BQUlFLFdBQVcsK0VBQWY7QUFDQSxNQUFJQyxjQUFjTCxTQUFTTSxhQUFULENBQXVCLE1BQXZCLENBQWxCO0FBQ0FELGNBQVlFLEdBQVosR0FBa0IsWUFBbEI7QUFDQUYsY0FBWUcsSUFBWixHQUFtQixVQUFuQjtBQUNBSCxjQUFZSSxJQUFaLEdBQW1CTCxRQUFuQjtBQUNBLE1BQUdMLGFBQUgsRUFBa0I7QUFDakJBLGlCQUFjVyxVQUFkLENBQXlCQyxZQUF6QixDQUFzQ04sV0FBdEMsRUFBbUROLGFBQW5EO0FBQ0EsR0FGRCxNQUVPO0FBQ05DLFlBQVNHLGFBQVQsQ0FBdUIscUJBQXZCLEVBQThDTyxVQUE5QyxDQUF5REUsV0FBekQsQ0FBcUVQLFdBQXJFO0FBQ0E7O0FBRURRLFdBQVNDLE9BQVQsQ0FBaUJaLG1CQUFtQmEsRUFBcEMsRUFBd0M7QUFDdkNDLGNBQVdDLHFCQUFxQkMsTUFETztBQUV2Q0Msd0JBQXFCRixxQkFBcUJFLG1CQUZIO0FBR3ZDQyxTQUFNSCxxQkFBcUJHLElBSFk7QUFJdkNDLGlCQUFjSixxQkFBcUJJLFlBSkk7QUFLdkNDLGFBQVVMLHFCQUFxQkssUUFMUTtBQU12Q0MsYUFBVU4scUJBQXFCTSxRQU5RO0FBT3ZDQyx3QkFBcUJQLHFCQUFxQk8sbUJBUEg7QUFRdkNDLG1CQUFnQlIscUJBQXFCUTtBQVJFLEdBQXhDO0FBVUEsRUEzQkQ7O0FBNkJBLEtBQUlDLGdCQUFnQixTQUFoQkEsYUFBZ0IsR0FBVztBQUM5QixNQUFJLE9BQU9oQyxPQUFPbUIsUUFBZCxLQUE0QixXQUFoQyxFQUE2QztBQUM1QyxPQUFJYyxZQUFZLDhFQUFoQjtBQUNBLE9BQUlDLGVBQWU1QixTQUFTTSxhQUFULENBQXVCLFFBQXZCLENBQW5CO0FBQ0FzQixnQkFBYUMsR0FBYixHQUFtQkYsU0FBbkI7QUFDQUMsZ0JBQWFFLE1BQWIsR0FBc0I3QixZQUF0Qjs7QUFFQSxPQUFHRixhQUFILEVBQWtCO0FBQ2pCQSxrQkFBY1csVUFBZCxDQUF5QkMsWUFBekIsQ0FBc0NpQixZQUF0QyxFQUFvRDdCLGFBQXBEO0FBQ0EsSUFGRCxNQUVPO0FBQ05DLGFBQVNHLGFBQVQsQ0FBdUIscUJBQXZCLEVBQThDTyxVQUE5QyxDQUF5REUsV0FBekQsQ0FBcUVnQixZQUFyRTtBQUNBO0FBQ0Q7QUFDRCxFQWJEOztBQWVBLEtBQUc1QixTQUFTK0IsVUFBVCxLQUF3QixVQUF4QixJQUF1Qy9CLFNBQVMrQixVQUFULEtBQXdCLFNBQXhCLElBQXFDLENBQUMvQixTQUFTZ0MsZUFBVCxDQUF5QkMsUUFBekcsRUFBb0g7QUFDbkhQO0FBQ0EsRUFGRCxNQUVPO0FBQ04xQixXQUFTa0MsZ0JBQVQsQ0FBMEIsa0JBQTFCLEVBQThDUixhQUE5QztBQUNBO0FBQ0QsQ0F4REEsR0FBRCIsImZpbGUiOiJTaG9wL0phdmFzY3JpcHQvRWFzeUNyZWRpdExvYWRlci5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gICBFYXN5Q3JlZGl0TG9hZGVyLmpzIDIwMjAtMDQtMDhcbiAgIEdhbWJpbyBHbWJIXG4gICBodHRwOi8vd3d3LmdhbWJpby5kZVxuICAgQ29weXJpZ2h0IChjKSAyMDE5IEdhbWJpbyBHbWJIXG4gICBSZWxlYXNlZCB1bmRlciB0aGUgR05VIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgKFZlcnNpb24gMilcbiAgIFtodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMvZ3BsLTIuMC5odG1sXVxuICAgLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiovXG5cbihmdW5jdGlvbigpIHtcblx0aWYgKHdpbmRvdy5Ob2RlTGlzdCAmJiAhTm9kZUxpc3QucHJvdG90eXBlLmZvckVhY2gpIHtcblx0XHROb2RlTGlzdC5wcm90b3R5cGUuZm9yRWFjaCA9IEFycmF5LnByb3RvdHlwZS5mb3JFYWNoO1xuXHR9XG5cdFxuXHRsZXQgY3VycmVudFNjcmlwdCA9IGRvY3VtZW50LmN1cnJlbnRTY3JpcHQ7XG5cblx0bGV0IHBsdWdpbkxvYWRlZCA9IGZ1bmN0aW9uKCkge1xuXHRcdGxldCBwbGFjZWhvbGRlckVsZW1lbnQgPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yKCdkaXYuZWFzeWNyZWRpdC1yci1jb250YWluZXInKTtcblx0XHRpZighcGxhY2Vob2xkZXJFbGVtZW50KSB7XG5cdFx0XHRyZXR1cm47XG5cdFx0fVxuXHRcdFxuXHRcdGxldCBzdHlsZVNyYyA9ICdodHRwczovL3JhdGVua2F1Zi5lYXN5Y3JlZGl0LmRlL3JhdGVua2F1Zi9qcy9yYXRlbnJlY2huZXIvdjEvcmF0ZW5yZWNobmVyLmNzcyc7XG5cdFx0bGV0IHBsdWdpblN0eWxlID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnbGluaycpO1xuXHRcdHBsdWdpblN0eWxlLnJlbCA9ICdzdHlsZXNoZWV0Jztcblx0XHRwbHVnaW5TdHlsZS50eXBlID0gJ3RleHQvY3NzJztcblx0XHRwbHVnaW5TdHlsZS5ocmVmID0gc3R5bGVTcmM7XG5cdFx0aWYoY3VycmVudFNjcmlwdCkge1xuXHRcdFx0Y3VycmVudFNjcmlwdC5wYXJlbnROb2RlLmluc2VydEJlZm9yZShwbHVnaW5TdHlsZSwgY3VycmVudFNjcmlwdCk7XG5cdFx0fSBlbHNlIHtcblx0XHRcdGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJ3NjcmlwdDpsYXN0LW9mLXR5cGUnKS5wYXJlbnROb2RlLmFwcGVuZENoaWxkKHBsdWdpblN0eWxlKTtcblx0XHR9XG5cdFx0XG5cdFx0cmtQbHVnaW4uYW56ZWlnZShwbGFjZWhvbGRlckVsZW1lbnQuaWQsIHtcblx0XHRcdHdlYnNob3BJZDogZWFzeUNyZWRpdFBhcmFtZXRlcnMuc2hvcElkLFxuXHRcdFx0ZmluYW56aWVydW5nc2JldHJhZzogZWFzeUNyZWRpdFBhcmFtZXRlcnMuZmluYW56aWVydW5nc2JldHJhZyxcblx0XHRcdGV1cm86IGVhc3lDcmVkaXRQYXJhbWV0ZXJzLmV1cm8sXG5cdFx0XHR0ZXh0VmFyaWFudGU6IGVhc3lDcmVkaXRQYXJhbWV0ZXJzLnRleHRWYXJpYW50ZSxcblx0XHRcdGxpbmtUZXh0OiBlYXN5Q3JlZGl0UGFyYW1ldGVycy5saW5rVGV4dCxcblx0XHRcdGZyb21UZXh0OiBlYXN5Q3JlZGl0UGFyYW1ldGVycy5mcm9tVGV4dCxcblx0XHRcdGluc3RhbGxtZW50VGVtcGxhdGU6IGVhc3lDcmVkaXRQYXJhbWV0ZXJzLmluc3RhbGxtZW50VGVtcGxhdGUsXG5cdFx0XHR3aWRnZXRUZW1wbGF0ZTogZWFzeUNyZWRpdFBhcmFtZXRlcnMud2lkZ2V0VGVtcGxhdGVcblx0XHR9KTtcblx0fVxuXHRcblx0bGV0IHJlYWR5Q2FsbGJhY2sgPSBmdW5jdGlvbigpIHtcblx0XHRpZiAodHlwZW9mKHdpbmRvdy5ya1BsdWdpbikgPT09ICd1bmRlZmluZWQnKSB7XG5cdFx0XHRsZXQgcGx1Z2luU3JjID0gJ2h0dHBzOi8vcmF0ZW5rYXVmLmVhc3ljcmVkaXQuZGUvcmF0ZW5rYXVmL2pzL3JhdGVucmVjaG5lci92MS9yYXRlbnJlY2huZXIuanMnO1xuXHRcdFx0bGV0IHBsdWdpblNjcmlwdCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ3NjcmlwdCcpO1xuXHRcdFx0cGx1Z2luU2NyaXB0LnNyYyA9IHBsdWdpblNyYztcblx0XHRcdHBsdWdpblNjcmlwdC5vbmxvYWQgPSBwbHVnaW5Mb2FkZWQ7XG5cdFx0XHRcblx0XHRcdGlmKGN1cnJlbnRTY3JpcHQpIHtcblx0XHRcdFx0Y3VycmVudFNjcmlwdC5wYXJlbnROb2RlLmluc2VydEJlZm9yZShwbHVnaW5TY3JpcHQsIGN1cnJlbnRTY3JpcHQpO1xuXHRcdFx0fSBlbHNlIHtcblx0XHRcdFx0ZG9jdW1lbnQucXVlcnlTZWxlY3Rvcignc2NyaXB0Omxhc3Qtb2YtdHlwZScpLnBhcmVudE5vZGUuYXBwZW5kQ2hpbGQocGx1Z2luU2NyaXB0KTtcblx0XHRcdH1cblx0XHR9XG5cdH07XG5cdFxuXHRpZihkb2N1bWVudC5yZWFkeVN0YXRlID09PSAnY29tcGxldGUnIHx8IChkb2N1bWVudC5yZWFkeVN0YXRlICE9PSAnbG9hZGluZycgJiYgIWRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5kb1Njcm9sbCkpIHtcblx0XHRyZWFkeUNhbGxiYWNrKCk7XG5cdH0gZWxzZSB7XG5cdFx0ZG9jdW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignRE9NQ29udGVudExvYWRlZCcsIHJlYWR5Q2FsbGJhY2spO1xuXHR9XG59KCkpO1xuIl19
